goog.provide('com.wsscode.edn_LT___GT_json');
goog.require('cljs.core');
goog.require('clojure.edn');
goog.require('clojure.string');
goog.require('goog.object');
/**
 * Return true for simple JS types. The intended use of this function is to detect if
 *   a value should be stored in its original form, for values that return false here, its
 *   expected that they get some encoding process before ending up as a JS value.
 */
com.wsscode.edn_LT___GT_json.simple_js_type_QMARK_ = (function com$wsscode$edn_LT___GT_json$simple_js_type_QMARK_(x){
return ((typeof x === 'string') || (typeof x === 'number') || (cljs.core.boolean_QMARK_.call(null,x)) || ((x == null)) || ((void 0 === x)));
});
com.wsscode.edn_LT___GT_json.encode_key = (function com$wsscode$edn_LT___GT_json$encode_key(x){
if((((x instanceof cljs.core.Keyword)) || (typeof x === 'number') || (typeof x === 'string'))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
} else {
return ["__edn-key|",cljs.core.pr_str.call(null,x)].join('');

}
});
com.wsscode.edn_LT___GT_json.decode_key = (function com$wsscode$edn_LT___GT_json$decode_key(s){
if(clojure.string.starts_with_QMARK_.call(null,s,":")){
return cljs.core.keyword.call(null,cljs.core.subs.call(null,s,(1)));
} else {
if(clojure.string.starts_with_QMARK_.call(null,s,"__edn-key|")){
return clojure.edn.read_string.call(null,cljs.core.subs.call(null,s,(("__edn-key|").length)));
} else {
return s;

}
}
});
/**
 * Recursively transforms ClojureScript values to JavaScript.
 * 
 *   The encoded JSON will have extra notation to enable a better deserialization
 *   later, keeping complex keys, keyword keys (simple and qualified), also encode
 *   extended types like UUID and dates. Using json->edn you can restore the original
 *   data from the JSON.
 * 
 *   Some things that don't get restored:
 * 
 *   - metadata is lost
 *   - number keys on maps will be turned into strings on the conversion back
 * 
 *   Other than that, all printable values should encode and decode with fidelity.
 */
com.wsscode.edn_LT___GT_json.edn__GT_json = (function com$wsscode$edn_LT___GT_json$edn__GT_json(var_args){
var G__40072 = arguments.length;
switch (G__40072) {
case 1:
return com.wsscode.edn_LT___GT_json.edn__GT_json.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.edn_LT___GT_json.edn__GT_json.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.edn_LT___GT_json.edn__GT_json.cljs$core$IFn$_invoke$arity$1 = (function (x){
return com.wsscode.edn_LT___GT_json.edn__GT_json.call(null,x,cljs.core.PersistentArrayMap.EMPTY);
}));

(com.wsscode.edn_LT___GT_json.edn__GT_json.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var thisfn = (function com$wsscode$edn_LT___GT_json$thisfn(x__$1){
if(com.wsscode.edn_LT___GT_json.simple_js_type_QMARK_.call(null,x__$1)){
return x__$1;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js.call(null,x__$1);
} else {
if(cljs.core.map_QMARK_.call(null,x__$1)){
var m = ({});
var seq__40099_40125 = cljs.core.seq.call(null,x__$1);
var chunk__40100_40126 = null;
var count__40101_40127 = (0);
var i__40102_40128 = (0);
while(true){
if((i__40102_40128 < count__40101_40127)){
var vec__40109_40129 = cljs.core._nth.call(null,chunk__40100_40126,i__40102_40128);
var k_40130 = cljs.core.nth.call(null,vec__40109_40129,(0),null);
var v_40131 = cljs.core.nth.call(null,vec__40109_40129,(1),null);
goog.object.set(m,com.wsscode.edn_LT___GT_json.encode_key.call(null,k_40130),com$wsscode$edn_LT___GT_json$thisfn.call(null,v_40131));


var G__40132 = seq__40099_40125;
var G__40133 = chunk__40100_40126;
var G__40134 = count__40101_40127;
var G__40135 = (i__40102_40128 + (1));
seq__40099_40125 = G__40132;
chunk__40100_40126 = G__40133;
count__40101_40127 = G__40134;
i__40102_40128 = G__40135;
continue;
} else {
var temp__5735__auto___40137 = cljs.core.seq.call(null,seq__40099_40125);
if(temp__5735__auto___40137){
var seq__40099_40138__$1 = temp__5735__auto___40137;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40099_40138__$1)){
var c__4609__auto___40139 = cljs.core.chunk_first.call(null,seq__40099_40138__$1);
var G__40140 = cljs.core.chunk_rest.call(null,seq__40099_40138__$1);
var G__40141 = c__4609__auto___40139;
var G__40142 = cljs.core.count.call(null,c__4609__auto___40139);
var G__40143 = (0);
seq__40099_40125 = G__40140;
chunk__40100_40126 = G__40141;
count__40101_40127 = G__40142;
i__40102_40128 = G__40143;
continue;
} else {
var vec__40112_40144 = cljs.core.first.call(null,seq__40099_40138__$1);
var k_40145 = cljs.core.nth.call(null,vec__40112_40144,(0),null);
var v_40146 = cljs.core.nth.call(null,vec__40112_40144,(1),null);
goog.object.set(m,com.wsscode.edn_LT___GT_json.encode_key.call(null,k_40145),com$wsscode$edn_LT___GT_json$thisfn.call(null,v_40146));


var G__40147 = cljs.core.next.call(null,seq__40099_40138__$1);
var G__40148 = null;
var G__40149 = (0);
var G__40150 = (0);
seq__40099_40125 = G__40147;
chunk__40100_40126 = G__40148;
count__40101_40127 = G__40149;
i__40102_40128 = G__40150;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_.call(null,x__$1)){
var arr = [];
if(cljs.core.set_QMARK_.call(null,x__$1)){
arr.push("__edn-list-type|set");
} else {
if(cljs.core.list_QMARK_.call(null,x__$1)){
arr.push("__edn-list-type|list");
} else {
}
}

var seq__40115_40152 = cljs.core.seq.call(null,cljs.core.map.call(null,com$wsscode$edn_LT___GT_json$thisfn,x__$1));
var chunk__40116_40153 = null;
var count__40117_40154 = (0);
var i__40118_40155 = (0);
while(true){
if((i__40118_40155 < count__40117_40154)){
var x_40156__$2 = cljs.core._nth.call(null,chunk__40116_40153,i__40118_40155);
arr.push(x_40156__$2);


var G__40157 = seq__40115_40152;
var G__40158 = chunk__40116_40153;
var G__40159 = count__40117_40154;
var G__40160 = (i__40118_40155 + (1));
seq__40115_40152 = G__40157;
chunk__40116_40153 = G__40158;
count__40117_40154 = G__40159;
i__40118_40155 = G__40160;
continue;
} else {
var temp__5735__auto___40161 = cljs.core.seq.call(null,seq__40115_40152);
if(temp__5735__auto___40161){
var seq__40115_40162__$1 = temp__5735__auto___40161;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40115_40162__$1)){
var c__4609__auto___40164 = cljs.core.chunk_first.call(null,seq__40115_40162__$1);
var G__40165 = cljs.core.chunk_rest.call(null,seq__40115_40162__$1);
var G__40166 = c__4609__auto___40164;
var G__40167 = cljs.core.count.call(null,c__4609__auto___40164);
var G__40168 = (0);
seq__40115_40152 = G__40165;
chunk__40116_40153 = G__40166;
count__40117_40154 = G__40167;
i__40118_40155 = G__40168;
continue;
} else {
var x_40169__$2 = cljs.core.first.call(null,seq__40115_40162__$1);
arr.push(x_40169__$2);


var G__40170 = cljs.core.next.call(null,seq__40115_40162__$1);
var G__40171 = null;
var G__40172 = (0);
var G__40173 = (0);
seq__40115_40152 = G__40170;
chunk__40116_40153 = G__40171;
count__40117_40154 = G__40172;
i__40118_40155 = G__40173;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return ["__edn-value|",cljs.core.pr_str.call(null,x__$1)].join('');

}
}
}
}
});
return thisfn.call(null,x);
}));

(com.wsscode.edn_LT___GT_json.edn__GT_json.cljs$lang$maxFixedArity = 2);

com.wsscode.edn_LT___GT_json.js_obj_QMARK_ = (function com$wsscode$edn_LT___GT_json$js_obj_QMARK_(x){
return (cljs.core.type.call(null,x) === Object);
});
com.wsscode.edn_LT___GT_json.list_type = (function com$wsscode$edn_LT___GT_json$list_type(x){
var f = (x[(0)]);
if(typeof f === 'string'){
if(clojure.string.starts_with_QMARK_.call(null,f,"__edn-list-type|")){
return cljs.core.subs.call(null,f,(("__edn-list-type|").length));
} else {
return false;
}
} else {
return false;
}
});
/**
 * Recursively transforms JavaScript arrays into ClojureScript
 *   vectors, and JavaScript objects into ClojureScript maps.
 * 
 *   Use to get fidelity restore of JSON data encoded with edn->json.
 */
com.wsscode.edn_LT___GT_json.json__GT_edn = (function com$wsscode$edn_LT___GT_json$json__GT_edn(var_args){
var G__40120 = arguments.length;
switch (G__40120) {
case 1:
return com.wsscode.edn_LT___GT_json.json__GT_edn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.edn_LT___GT_json.json__GT_edn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.edn_LT___GT_json.json__GT_edn.cljs$core$IFn$_invoke$arity$1 = (function (x){
return com.wsscode.edn_LT___GT_json.json__GT_edn.call(null,x,cljs.core.PersistentArrayMap.EMPTY);
}));

(com.wsscode.edn_LT___GT_json.json__GT_edn.cljs$core$IFn$_invoke$arity$2 = (function (x,opts){
var f = (function com$wsscode$edn_LT___GT_json$thisfn(x__$1){
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeClojure$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeClojure,x__$1):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeClojure,x__$1))){
return cljs.core._js__GT_clj.call(null,x__$1,cljs.core.apply.call(null,cljs.core.array_map,opts));
} else {
if(cljs.core.seq_QMARK_.call(null,x__$1)){
return cljs.core.doall.call(null,cljs.core.map.call(null,com$wsscode$edn_LT___GT_json$thisfn,x__$1));
} else {
if(cljs.core.map_entry_QMARK_.call(null,x__$1)){
return (new cljs.core.MapEntry(com$wsscode$edn_LT___GT_json$thisfn.call(null,cljs.core.key.call(null,x__$1)),com$wsscode$edn_LT___GT_json$thisfn.call(null,cljs.core.val.call(null,x__$1)),null));
} else {
if(cljs.core.coll_QMARK_.call(null,x__$1)){
return cljs.core.into.call(null,cljs.core.empty.call(null,x__$1),cljs.core.map.call(null,com$wsscode$edn_LT___GT_json$thisfn),x__$1);
} else {
if(cljs.core.array_QMARK_.call(null,x__$1)){
var lt = com.wsscode.edn_LT___GT_json.list_type.call(null,x__$1);
return cljs.core.into.call(null,(function (){var G__40122 = lt;
switch (G__40122) {
case "list":
return cljs.core.List.EMPTY;

break;
case "set":
return cljs.core.PersistentHashSet.EMPTY;

break;
default:
return cljs.core.PersistentVector.EMPTY;

}
})(),cljs.core.map.call(null,com$wsscode$edn_LT___GT_json$thisfn),(function (){var G__40123 = cljs.core.array_seq.call(null,x__$1);
var G__40123__$1 = (cljs.core.truth_(lt)?cljs.core.drop.call(null,(1),G__40123):G__40123);
if(cljs.core._EQ_.call(null,lt,"list")){
return cljs.core.reverse.call(null,G__40123__$1);
} else {
return G__40123__$1;
}
})());
} else {
if(((typeof x__$1 === 'string') && (clojure.string.starts_with_QMARK_.call(null,x__$1,"__edn-value|")))){
return clojure.edn.read_string.call(null,cljs.core.subs.call(null,x__$1,(("__edn-value|").length)));
} else {
if((cljs.core.type.call(null,x__$1) === Object)){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (r,k){
return cljs.core.assoc_BANG_.call(null,r,com.wsscode.edn_LT___GT_json.decode_key.call(null,k),com$wsscode$edn_LT___GT_json$thisfn.call(null,goog.object.get(x__$1,k)));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),cljs.core.js_keys.call(null,x__$1)));
} else {
return x__$1;

}
}
}
}
}
}
}
});
return f.call(null,x);
}));

(com.wsscode.edn_LT___GT_json.json__GT_edn.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=com.wsscode.edn<_>json.js.map
